/**********
* File: CDGL_IDirect3DSwapChain9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DSwapChain9. 
					 This class is the concrete implementation of IDirect3DSwapChain9 interface. The IDirect3DSwapChain9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 17Mar05

* Change History (Most Recent First):

**********/

#ifndef __CDGL_IDIRECT3DSWAPCHAIN9_H__
#define __CDGL_IDIRECT3DSWAPCHAIN9_H__

#include <Carbon/Carbon.h>
#include "d3d9.h"

class CDGL_IDirect3DSwapChain9 : public IDirect3DSwapChain9
{
	public:
	
		CDGL_IDirect3DSwapChain9(IDirect3DDevice9 *in_pDevice);
		~CDGL_IDirect3DSwapChain9();
		
		 /*** IUnknown methods ***/
		HRESULT QueryInterface( REFIID riid, void** ppvObj);
		ULONG AddRef();
		ULONG Release();

		/*** IDirect3DSwapChain9 methods ***/
		HRESULT Present( CONST RECT* pSourceRect,CONST RECT* pDestRect,HWND hDestWindowOverride,CONST RGNDATA* pDirtyRegion,DWORD dwFlags);
		HRESULT GetFrontBufferData( IDirect3DSurface9* pDestSurface);
		HRESULT GetBackBuffer( UINT iBackBuffer,D3DBACKBUFFER_TYPE Type,IDirect3DSurface9** ppBackBuffer);
		HRESULT GetRasterStatus( D3DRASTER_STATUS* pRasterStatus);
		HRESULT GetDisplayMode( D3DDISPLAYMODE* pMode);
		HRESULT GetDevice( IDirect3DDevice9** ppDevice);
		HRESULT GetPresentParameters( D3DPRESENT_PARAMETERS* pPresentationParameters);

		
	private:
		IDirect3DDevice9 *		m_pDevice;
		int						m_lRefCount;
};

#endif //__CDGL_IDIRECT3DSWAPCHAIN9_H__

